define(["angular", "app"], function (angular, app, moment) {
	"use strict";
	app.controller("UserGuideController", function ($scope, $state, $stateParams, focusService, $window,
		$modal,globalDelayTracker, $timeout, $location, $anchorScroll,UserGuideConstants,modalService) {
        		
		$scope.globalDelayTracker = globalDelayTracker;		
		$scope.sectionTitle = "Help";
		$scope.isPhoneView = $window.innerWidth < 768;

		angular.extend($scope, UserGuideConstants);
		focusService.focusMain();

		var onViewChange = function () {
            focusService.focusPrimary();
        };
        $scope.$on('$viewContentLoaded', onViewChange);

		$scope.scrollTo = function(id) {			
			var old = $location.hash();
      		$location.hash(id);
      		$anchorScroll(id);
      		$location.hash(old);
      		focusService.focusElement('#'+id,true);
   		}

		$scope.externalLink = function (link) {
			
			var modalOptions = {
				closeButtonText: 'No',
				actionButtonText: 'Yes',
				headerText: 'Exit FitHeart?',
				bodyText:   'Are you sure you wish to leave the application?',
				centerBody: true
			};
			modalService.showModal({}, modalOptions).then(function() { 
				switch(link) {
					case "launchpad" : 
						window.location = window.location.origin +  "/launchpad";
						break;
					default : 
						window.location = link;
						break;
				}			
			}, function() {								
			});							

		};

	});
});